// ##VER: 02 ##NOTE: Convert GIF/JPG to BYTE this version actully works!

import java.awt.*;
import java.awt.image.*;
import java.io.*;
import java.awt.event.*;


public class img2byte extends Frame 
{
	static Image im=null;
	static int W=-1,H=-1;

	public img2byte()	{} 

    	public static void main(String args[])
    	{
		String infile,outfile;
		infile="UNSPECIFIED";
		outfile="UNSPECIFIED";
		boolean paramsOK=false,mode=false;
		if (args.length <= 1) {
			usage();
			paramsOK=false;
		} 
		if (args.length == 2) {
			infile = args[0];
			outfile = args[1];
			paramsOK=true;
		}
		if (args.length >= 3) {
			infile = args[0];
			outfile = args[1];
			if (args[2].equals("/I") || args[2].equals("/i")) {
				System.out.println("img2byte is running in inverse mode");
				mode=true;
			} else {
				System.out.println("Unreconised params ignored");
				usage();
			}
			paramsOK=true;
		}
		if (paramsOK) {
			System.out.println("IMG2BYTE :");
			System.out.println("  image file  " + infile);
			System.out.println("  data file   " + outfile);
			img2byte widow = new img2byte();
			System.out.println("IMG2BYTE : Loading image file");
			if (widow.processFile(infile)==false) {
				System.exit(0);
			} 			
			System.out.println("IMG2BYTE : Saving data file");
			saveByteData(outfile,mode);
			System.exit(0);
		}
    	}

	public static void saveByteData(String fn,boolean i)
	{
		int[] grabMapXY;
		grabMapXY		= 	new int[(W * H)];

		PixelGrabber pg = new PixelGrabber(im,0,0,W,H,grabMapXY,0,W); 			
		// start grab
		try {
			pg.grabPixels();
		} catch (InterruptedException e) {
			System.out.println("Map grab failed : " + e);
			return;
		}
		if ((pg.status() & ImageObserver.ABORT) != 0) {
			System.out.println("Map grab failed !");
			return;
		}	
		int first=-1,pix,byt=0;
		String outByte,bw;
		// need to base r on number of valid pixels
		bw="";
		for (int y =0; y < H; y++) {	
			outByte="    .byte %";
			for (int x =0; x < W; x++) {
				if (byt==8) {
					if (outByte!="    .byte %") {
						outByte=outByte+",%";
					}
					byt=1;
				} else {
					byt++;
				}
				bw ="";
				pix=grabMapXY[ y * W + x ];
				// add the pixel
				if (first==-1) { first=pix; }
				if (pix == first) {
					bw="0";
				} else {
					bw="1";
				}
				if (i) {
					if (bw=="0") {
						bw="1";
					} else {
						bw="0";
					}
				}
				outByte=outByte+bw;
			}
			System.out.println(outByte);
			writeToFn(fn,outByte);
		}
	}

	public static void writeToFn(String fn,String Dbytes) {
		try {
			DataOutputStream dos = new DataOutputStream( new FileOutputStream(fn,true));
			dos.writeBytes(Dbytes); // store error
			dos.writeByte(13); // line feed for each line
           		dos.writeByte(10); // line feed for each line 
			// close here
			dos.close();
     		} catch (IOException e) {
    			System.err.println("File error: " + e.getMessage());
        	}
	}


	public boolean processFile(String fn)
	{
		boolean OK=false;
		int exitcounter;
		try {
			im = getToolkit().getImage(fn);
		}
		catch (Exception e) 
		{
			System.out.println("1HOLY MOLY THIS NEVER HAPPENS!!!! "+e);
		} 
		MediaTracker tracker= new MediaTracker(this);
		tracker.addImage(im,0);
		try {
			tracker.waitForID(0);
		} 
		catch (InterruptedException e) 
		{
			System.out.println("2HOLY MOLY THIS NEVER HAPPENS "+e);
		} 
		if (tracker.isErrorID(0)) {
			System.out.println("IMAGE FILE COULD NOT BE LOADED");
			System.out.println(fn);
		} else {
			exitcounter=0;
			while ( ((W==-1)||(H==-1)) && (exitcounter<=16000) ) {
				W=im.getWidth(null);
				H=im.getHeight(null);
				exitcounter++;
			}
			if (exitcounter>15999) {
				System.out.println("Timeout attempting to load image, is it to big?");
			} else {
				OK=true;
			}
		}
		return(OK);
	}

















	public static void usage() {
		System.out.println("Usage:");
		System.out.println("java img2byte infile outfile [/i]");
		System.out.println(" infile  : image file .gif (width divisable by 8");
		System.out.println(" outfile : text file to be created");
		System.out.println(" /i      : Inverse data ");
	}


}	// end of class
