// ##VER: 01 ##NOTE: Convert GIF/JPG  ICON BYTE this version actully works!
// taken from the now famous img2byte / img2html 

import java.awt.*;
import java.awt.image.*;
import java.io.*;
import java.awt.event.*;
import java.util.*;	// needed for vectors


public class img2iconbyte extends Frame 
{
	static Image im=null;
	static int W=-1,H=-1;
	static int imgarray[];
	static Vector palette = new Vector(); 

	public img2iconbyte()	{} 		// do nothing, be nothing

    	public static void main(String args[])
    	{
		String infile,outfile;
		infile="UNSPECIFIED";
		outfile="UNSPECIFIED";
		boolean paramsOK=false,mode=false;
		if (args.length <= 1) {
			usage();
			paramsOK=false;
		} 
		if (args.length == 2) {
			infile = args[0];
			outfile = args[1];
			paramsOK=true;
		}
		if (args.length >= 3) {
			infile = args[0];
			outfile = args[1];
			System.out.println("Unreconised params ignored");
			usage();
			paramsOK=true;
		}
		if (paramsOK) {
			imgarray = new int[32*32];
			System.out.println("img2iconbyte :");
			System.out.println("  image file  " + infile);
			System.out.println("  data file   " + outfile);
			img2iconbyte widow = new img2iconbyte();
			System.out.println("img2iconbyte : Loading image file");
			if (widow.processFile(infile)==false) {
				System.exit(0);
			} 			
			System.out.println("img2iconbyte : Saving data file");
			saveByteData(outfile,mode);
			System.exit(0);
		}
    	}

	public static void saveByteData(String fn,boolean zyi)
	{
		int[] grabMapXY;
		grabMapXY		= 	new int[(W * H)];

		PixelGrabber pg = new PixelGrabber(im,0,0,W,H,grabMapXY,0,W); 			
		// start grab
		try {
			pg.grabPixels();
		} catch (InterruptedException e) {
			System.out.println("Map grab failed : " + e);
			return;
		}
		if ((pg.status() & ImageObserver.ABORT) != 0) {
			System.out.println("Map grab failed !");
			return;
		}	
		int first=-1,pix,index;
		String outByte,bw;
		bw="";
		RGBnibble rgbn;
		RGBnibble temp;
		for (int y =0; y < H; y++) {	
			for (int x =0; x < W; x++) {
				pix=grabMapXY[ y * W + x ];
				rgbn = new RGBnibble(new Color(pix));
				index=-1;
				//System.out.println("[" + palette.size() + "] "+rgbn.asHexString());
				for (int i=0;i<palette.size();i++) {
					temp = (RGBnibble)palette.elementAt(i);
					if (temp.asHexString().equals(rgbn.asHexString())) {
						index=i;
						i=palette.size();
					}
				}
				if (index==-1) {
					if (palette.size() < 16 ) {
						index=palette.size();
						palette.addElement(rgbn);
					} else {
						System.out.println("Palette has more than 16 colors, extra colors will become index 0");
						index=0;
					}
				}
				//System.out.println("color index = " + index);
				imgarray[y * W + x] = index;
			}
		}
		// the image has been subjigated
		// output the palette
		writeToFn(fn,"* ------------------");
		writeToFn(fn,"* Icon data created with img2iconbyte ");
		writeToFn(fn,"*");
		writeToFn(fn,"* rednuht 2000, www.jumpstation.co.uk ");
		writeToFn(fn,"* ------------------");
		writeToFn(fn,"");
		writeToFn(fn,"    .org    $260    ; correct location for the palette");
		writeToFn(fn,"");
		for (int i=0;i<palette.size();i++) {
			temp = (RGBnibble)palette.elementAt(i);
			writeToFn(fn,"    .word   $" +temp.asHexString());
		}
		for (int i=palette.size();i<16;i++) {
			writeToFn(fn,"    .word   $FFFF    ; there was no palete entry so you just get white");
		}
		writeToFn(fn,"");
		writeToFn(fn,"");
		writeToFn(fn,"    .org    $280    ; correct location for the 1st icon image");
		writeToFn(fn,"");
		// great thing at this point is unlike my other img2 progies we are garentied
		// a array of 32x32 (from an image of the same)
		String oneLine;
		for (int y =0; y < H; y++) {	
			oneLine="    .byte ";
			for (int x =0; x < W; x=x+2) {
				oneLine=oneLine+"$";
				oneLine=oneLine + nibbler(imgarray[ y * W + x ],imgarray[ y * W + x + 1]);
				oneLine=oneLine+",";
			}
			oneLine = oneLine.substring(0,oneLine.length()-1);
			writeToFn(fn,oneLine);
		}
	}

	public static String nibbler(int n1, int n2) {
		int r;
		String fr;
		r = n1 << 4;
		r = r | n2;
		fr = Integer.toHexString(r);
		if (fr.length()==1) { fr = "0" + fr; }
		return(fr);
	}

	public static void writeToFn(String fn,String Dbytes) {
		try {
			DataOutputStream dos = new DataOutputStream( new FileOutputStream(fn,true));
			dos.writeBytes(Dbytes); // store error
			dos.writeByte(13); // line feed for each line
           		dos.writeByte(10); // line feed for each line 
			// close here
			dos.close();
     		} catch (IOException e) {
    			System.err.println("File error: " + e.getMessage());
        	}
	}


	public boolean processFile(String fn)
	{
		boolean OK=false;
		int exitcounter;
		try {
			im = getToolkit().getImage(fn);
		}
		catch (Exception e) 
		{
			System.out.println("1HOLY MOLY THIS NEVER HAPPENS!!!! "+e);
		} 
		MediaTracker tracker= new MediaTracker(this);
		tracker.addImage(im,0);
		try {
			tracker.waitForID(0);
		} 
		catch (InterruptedException e) 
		{
			System.out.println("2HOLY MOLY THIS NEVER HAPPENS "+e);
		} 
		if (tracker.isErrorID(0)) {
			System.out.println("IMAGE FILE COULD NOT BE LOADED");
			System.out.println(fn);
		} else {
			exitcounter=0;
			while ( ((W==-1)||(H==-1)) && (exitcounter<=16000) ) {
				W=im.getWidth(null);
				H=im.getHeight(null);
				exitcounter++;
			}
			if (exitcounter>15999) {
				System.out.println("Timeout attempting to load image, is it to big?");
			} else {
				OK=true;
			}
		}
		if ((W>32) || (H>32)) {	
			System.out.println("Image must be 32x32 to be a VMU icon");
			System.out.println("This image is " + W + "x" + H);
			OK=false;
		} 
		return(OK);
	}


	public static void usage() {
		System.out.println("Usage:");
		System.out.println("java img2iconbyte infile outfile ");
		System.out.println(" infile  : image file .gif (width = 32, height = 32 )");
		System.out.println(" outfile : text file to be created");
	}


}	// end of class


// data class for nibble color emements
class RGBnibble
{
	int R,G,B;
	int id;
	Color c;

	// is initialised with a normal RGB color and converted
	public RGBnibble(Color ic) 
	{
		c = ic;
		R = ic.getRed();
		G = ic.getGreen();
		B = ic.getBlue();
		//System.out.print("R:" + Integer.toHexString(R));
		R = R >> 4;
		//System.out.println(" R:" + Integer.toHexString(R));
		//System.out.print("G:" + Integer.toHexString(G));
		G = G >> 4;
		//System.out.println(" G:" + Integer.toHexString(G));
		//System.out.print("B:" + Integer.toHexString(B));
		B = B >> 4;
		//System.out.println(" B:" + Integer.toHexString(B));
	}

	// returns a 4 character string = ARGB as hex
	public String asHexString() {
		int preA,preB;
		String returnA,returnB;
		preA = 255 >> 4;	// gives us the alpha
		preA = preA << 4; // makes room for red
		preA = preA | R;  // OR the high binary with the low
		preB = G << 4;    // makes room for blue
		preB = preB | B;  // OR the high binary with the low
		returnA = Integer.toHexString(preA);
		if (returnA.length()==1) { returnA = "0" + returnA; }
		returnB = Integer.toHexString(preB);
		if (returnB.length()==1) { returnB = "0" + returnB; }
		return(returnA + returnB);
	}


} // end of class


