// rednuht 2001 (01)
// rndurl reads a source list file/s and generates random urls in at least the following forms.
// simple each line is a url
// each line is a word in a url i.e http://www.WORD.com
// from two word lists a single url is created. i.e. http://www.WORD1WORD2.com
// once any word lists necessary are loaded a random generator will output possible suggestions to the user
// where either a time delay or a click is required to instagate a new url either in this or a new window.
// then either the applet stops itself or continues to randomly generate urls.
// also has a param list of available TLD names .com/.net/org.co.uk etc
// if two word lists are supplied for joining then the load bar should be split in two

// v0.4 - use of class loadList confirmed good
// v0.8 - added fully threading to loadList and again proved to work OK in test enviroment.
// v1.3 - removed 3 way rnd urls to a scrolling varity, still no percentages on the count down.
// v1.14- Countdown works with percentages now, need to get from setup 
//			count down counter - possibly zero
// 			count down restart mode
//			url change counter
//			destination frame
//  13/01/2002 - Tidying up. v1.15
//  v1.15d found everything in a mess added nicness to none full restart
//  20 - 21 01/2002 - more messsing getting polygoning to look nicer
//  v1.20 03 02/2002 - Just testing, changed the Restartmode 0 to click to restart (works)
// v1.20r 03022002 - Final release version added error checking for the load system and integrated no problem with site

import java.applet.*;
import java.net.*;
import java.util.*;
import java.io.*;
import java.awt.*;
import java.awt.image.*;
import java.awt.Color.*;
import java.awt.event.*;

public class rndURL extends Applet implements Runnable , MouseListener
{
	String vNumber = "1.20r";
   	int aWidth, aHeight, globalDelay = 30;
   	Image offScreenBuf;
	int maxSource01=-1,maxSource02=-1;
	int cps01=1,cps02=1;	// current source if no index supplied, fake it !
	Thread rndURL = null;
	loadList wordList01,wordList02;
	String linkURL[];
	String portArray[],TLDArray[];
	int cDx,cDy,cDd=0,cDp;	// count down circle x,y and diameter, oh and the current percent
	int i1in,in1=20;	// one in,in one
	boolean URLMode = true; // default unless specified otherwise
	boolean beenHereDoneThat=false;
	int countDown=500;	// no it an't seconds, thats for sure
	Color cDCol;
	int restartMode = 2;	// 0 = now restart and halt, 1 = full restart and 2 = no restart but no halt
	String destFrame="_blank";
	int runmode=0;	// 0 = normal
	int globalt=0;
	int polyX[] = new int[12];
	int polyY[] = new int[12];

	public void init()
	{
		cDp = 0;
		linkURL = new String[3];
		portArray = new String[10];
		TLDArray = new String[10]; 
		String source01,source02;
		source01 = getParameter("source01");
		source02 = getParameter("source02");
		if (getParameter("maxSource01") != null) {
			maxSource01 = Integer.parseInt(getParameter("maxSource01"),10);
		      System.out.println("ms01 "+maxSource01);
		}
		if (getParameter("maxSource02") != null) {
			maxSource02 = Integer.parseInt(getParameter("maxSource02"),10);
		      System.out.println("ms02 "+maxSource02);
		}
		if (getParameter("delay") != null) {
			in1 = Integer.parseInt(getParameter("delay"),10);
		}	// else we use the default
		if (getParameter("countdown") != null) {
			countDown = Integer.parseInt(getParameter("countdown"),10);
		}	// else we use the default of 500
		// added 09/05/2001
		if (getParameter("runmode") != null) {
			runmode = Integer.parseInt(getParameter("runmode"),10);
		}	// else we use the default of 0
		System.out.println("runmode "+runmode);
		if (getParameter("restart") != null) {
			restartMode = Integer.parseInt(getParameter("restart"),10);
		} // else we use the default of "no restart and no halt"
		System.out.println("restartMode "+restartMode);
		if (getParameter("target") != null) {
			destFrame = getParameter("target");
		} // else we use the default of _blank
		for (int i=0;i<10;i++) {
			portArray[i] = getParameter("port"+i);
			TLDArray[i]  = getParameter("tld"+i);
		}
		// Get applet dimensions
		Dimension d = getSize();
	     	aHeight = d.height;
		aWidth = d.width;
		if (aWidth <=0) {	aWidth=10; }	// in case the applet is hidden
		if (aHeight<=0) {	aHeight=10; }	// in case the applet is hidden
		// init buffer
	     	offScreenBuf = createImage (aWidth, aHeight);
	      System.out.println("rndURL Version "+vNumber);
		wordList01 = new loadList();
		wordList01.loadListData(getCodeBase(),source01);
		wordList01.start();
		if (source02 != null) {
			wordList02 = new loadList();
			wordList02.loadListData(getCodeBase(),source02);
			wordList02.start();
			URLMode=false;	// if we have two its to do other stuff !!
		}
		addMouseListener(this);
		// define polygon initial form
		polyX[0] = 0;
		polyY[0] = 0;
		polyX[1] = 0;
		polyY[1] = aHeight/2;
		polyX[2] = 0;
		polyY[2] = aHeight;

		polyX[3] = (aWidth/4) * 1;
		polyY[3] = aHeight;
		polyX[4] = (aWidth/4) * 2;
		polyY[4] = aHeight;
		polyX[5] = (aWidth/4) * 3;
		polyY[5] = aHeight;

		polyX[6] = aWidth;
		polyY[6] = aHeight;
		polyX[7] = aWidth;
		polyY[7] = aHeight/2;
		polyX[8] = aWidth;
		polyY[8] = 0;

		polyX[9] = (aWidth/4) * 3;
		polyY[9] = 0;
		polyX[10] = (aWidth/4) * 2;
		polyY[10] = 0;
		polyX[11] = (aWidth/4) * 1;
		polyY[11] = 0;
	}

	// if we are fully loaded then next url/s please
	public void URLUpdate() {
		if (wordList01.loading == true || (wordList02 != null && wordList02.loading == true)) {
			// do less than nothing, this falls through to the default repaint
		} else {
			// update scrollies
			linkURL[2] =linkURL[1];
			linkURL[1] =linkURL[0];
			// check mode
			if (wordList02 == null) {
				// one word list
					linkURL[0] = wordList01.returnStrAtIndex(Randomize(wordList01.maxIndex));
			} else {
				// combine word lists
					linkURL[0] = wordList01.returnStrAtIndex(Randomize(wordList01.maxIndex));
					linkURL[0] = linkURL[0] + wordList02.returnStrAtIndex(Randomize(wordList02.maxIndex));
			}
			// special word creation mode
			if ((runmode==1) && (wordList02 != null)) {
				linkURL[0]="";	// clear out the basic concat string
				// rnd loop (2)+1
				int ir01,ir00=Randomize(2)+1;
				for (ir01=0;ir01<ir00;ir01++) {
					// cont(20)+ vowel+cont
					if (ir01==0) {
						linkURL[0]=linkURL[0] + wordList02.returnStrAtIndex(Randomize(78)); // force the first char to be a letter
					}
					linkURL[0] = linkURL[0] + wordList01.returnStrAtIndex(Randomize(wordList01.maxIndex));
					linkURL[0] = linkURL[0] + wordList02.returnStrAtIndex(Randomize(wordList02.maxIndex));
				}
				System.out.println("*_ " + linkURL[0]);
			}
			int overflowpipe;
			String port0,TLD0;
			int i4 =0;
			// if we are in url mode then thats it otherwise add necessary bits (inc http/ftp)
			if (!URLMode) {
				port0="";
				TLD0="";
				overflowpipe=0;
				while (port0=="" || port0==null && overflowpipe<=10 ) {
					port0=portArray[Randomize(10)];
					overflowpipe++;
				}
				if (overflowpipe>=10) {port0="http://www."; }
				// add port
				linkURL[i4] = port0 + linkURL[i4];
				overflowpipe=0;
				while (TLD0=="" || TLD0==null && overflowpipe<=10) {
					TLD0=TLDArray[Randomize(10)];
					overflowpipe++;
				}
				if (overflowpipe>=10) {TLD0=".com"; }
				// add tld
				linkURL[i4] = linkURL[i4] + TLD0;
			}
		}
		repaint();
	}

	public void paint (Graphics g)   {    
		// Create off screen buffers
		Graphics gBuff = offScreenBuf.getGraphics();
		gBuff.setColor(Color.white);
		gBuff.fillRect(0,0,aWidth,aHeight);
		// fixed width font
		Font fwf = new Font("Courier",Font.BOLD,14);
		gBuff.setFont(fwf);
		FontMetrics fm = gBuff.getFontMetrics(fwf);
		if (wordList01.loading ==false) {
		} else {
			// draw progress bar (over full applet)
			// calculate new length or display current
			if (maxSource01 < 1) {
				// no index supplied so we are using our own fake one.
				cps01 = cps01 + Randomize(4);
				if (cps01 > aWidth) {
					cps01 = 1;
				}
			} else {
				// do percent magic
				double inc01;
				inc01 = (double)aWidth / (double)maxSource01;
				// take total width and divide by the max possible
				// take this new incremental value and times it by the current 
				cps01 = (int)(inc01 * wordList01.maxIndex);
			}
			// draw bar
			gBuff.setColor(new Color(100,100,200));
			gBuff.fillRect(0,0,cps01,aHeight);
		}
		if (wordList02 != null ) {
		if (wordList02.loading ==false) {
		} else {
			// draw progress bar (over full applet)
			// calculate new length or display current
			if (maxSource02 < 1) {
				// no index supplied so we are using our own fake one.
				cps02 = cps02 + Randomize(4);
				if (cps02 > aWidth) {
					cps02 = 1;
				}
			} else {
				// do percent magic
				double inc02;
				inc02 = (double)aWidth / (double)maxSource02;
				// take total width and divide by the max possible
				// take this new incremental value and times it by the current 
				cps02 = (int)(inc02 * wordList02.maxIndex);
			}
			// draw bar
			gBuff.setColor(Color.white);
			gBuff.fillRect(0,15,aWidth,aHeight);
			gBuff.setColor(new Color(200,100,100));
			gBuff.fillRect(0,15,cps02,aHeight);
		}
		}
		// if loading
		if (wordList01.loading == true || (wordList02 != null && wordList02.loading == true)) {
			gBuff.setColor(Color.black);
			gBuff.drawString("LOADING", (aWidth/2)-(fm.stringWidth("LOADING")/2),21);
		} else {
			// get ready to rock
			gBuff.setColor(Color.white);
			gBuff.fillRect(0,0,aWidth,aHeight);
			
			if (cDp<=0) {
				// stop right here right now
				if (restartMode == 0 && beenHereDoneThat) { 
					activateURL();
					countDown=0;
					this.stop();
					cDp=10;
					// set polys to 0
					//setPolys(0);					
					//setPolys(30);
					restartMode=19;					
				}
				// restartMode = 1 always keep going with everything
				if (restartMode == 1  && beenHereDoneThat) {
					activateURL();
				}
				// stop the URL countdown but keep up the url cycling.
				if (restartMode == 2  && beenHereDoneThat) { 
					activateURL();
					countDown=0;
					cDp=10;
					// set polys to 0
					//setPolys(0);
					//setPolys(30);
					restartMode=21;					
				}
				cDCol = new Color(Randomize(100)+154,Randomize(100)+154,Randomize(100)+154);
				// reset count down module
				cDd = aWidth;
				cDx = 0;
				cDy = (0-(aWidth/2))+(aHeight/2);
				if (countDown>0) {
					cDp=countDown;
				}
				beenHereDoneThat=true;  // the 'only come here when the applet restarts' flag
			}
			if (countDown>0) {
				double incD;
				int tcDv;
				incD = (double)aWidth / (double)countDown;
				tcDv = (int)(incD * cDp);
				gBuff.setColor(cDCol);
				gBuff.fillOval(cDx,cDy,cDd,cDd);
				gBuff.setColor(Color.black);
				gBuff.drawOval(cDx,cDy,cDd,cDd);
				cDd=tcDv;
				cDx=((aWidth-cDd)/2);
				cDy=(0-((aWidth/2)-cDx))+(aHeight/2);
				// i am no good at maths yet this finaly seems to work !!
				cDp--;
			} else {
				// niceness added 13/01/2002
				// no countdown, but we are doing something funky.
				// cDCol is set and is not being used so we will pinch it.
				gBuff.setColor(cDCol);
				gBuff.fillPolygon(polyX, polyY, polyX.length);
				gBuff.setColor(Color.black);
				gBuff.drawPolygon(polyX, polyY, polyX.length);
				// shuffle all points
				if (restartMode>=20) {
					setPolys(1);
				} else {
					setPolys(1);
				}
			}
			// display url plus timer
			// active click through
			// reset timer if in MULTIBALL mode
			for (int i=0;i<3;i++) {
				if (linkURL[i] == null ) { linkURL[i]=""; }
			}
			gBuff.setColor(new Color(100,100,100));
			gBuff.drawString(linkURL[0], (aWidth/2)-(fm.stringWidth(linkURL[0])/2),4);
			gBuff.setColor(Color.black);
			gBuff.drawString(linkURL[1], (aWidth/2)-(fm.stringWidth(linkURL[1])/2),18);
			gBuff.setColor(new Color(100,100,100));
			gBuff.drawString(linkURL[2], (aWidth/2)-(fm.stringWidth(linkURL[2])/2),32);
			//System.out.print("_^.^_" );
		}
		// Draw buffer to main window
		g.drawImage(offScreenBuf,0,0,this);
	      // Save memory (ditch buffer)
		gBuff.dispose();
	}

	// do the nice polygon effect when not restarting 
	// added 13/01/2002 
	public void setPolys(int offset) {
		// if offset = 0 then set all to 0
		for (int i=0;i<polyX.length;i++) {
			if (offset == 0) {
				//polyX[i] = aWidth/2;
			} else {
				polyX[i] = shuffle(polyX[i],offset);
			}
			if (polyX[i] > aWidth+4) { polyX[i] = aWidth -4; }
			if (polyX[i] < -4) { polyX[i] = 0 ; }
		}
		for (int i=0;i<polyY.length;i++) {
			if (offset == 0) {
				//polyY[i] = aHeight/2;
			} else {
				polyY[i] = shuffle(polyY[i],offset);
			}
			if (polyY[i] > aHeight+5) { polyY[i] = aHeight -4 ; }
			if (polyY[i] < -5) { polyY[i] = 4 ; }
		}
		// I though the following would be bulit into a drawPolygon method, but no.
		polyX[polyX.length-1] = polyX[0];
		polyY[polyY.length-1] = polyY[0];
	}
	
	// take a [value] and apply a random positive of negitive [offset] to it.
	public int shuffle(int value,int offset) {
		int o;
		o = offset + offset + 1;  // this balances out the index of 0
		o = Randomize(o); 
		offset = offset - (offset + offset);
		offset = offset + o;
		//System.out.print(offset + " ");
		value=value+offset;
		return(value);
	}

	public void activateURL() {
		if (linkURL[1]!="" && linkURL[1] != null) {
			URL nURL;
			try {	
				if (linkURL[1].startsWith("http://")) {
					nURL= new URL(linkURL[1]);
				} else {
					nURL= new URL(getCodeBase(),linkURL[1]);
				}
		      	getAppletContext().showDocument(nURL,destFrame);
			}
        		catch(MalformedURLException mal){System.out.println("URL: could not be constructed from [" + linkURL[1] + "]");	      }
		}
	}

	public void mousePressed(MouseEvent e) {}	// does nothing for me

	public void mouseReleased(MouseEvent e) {	// ah, the power!
		// if allowed, pass to generate connection to new url
		if (wordList01.loading == true || (wordList02 != null && wordList02.loading == true)) {
			System.out.println("Oi! we are still loading here, patients is a virtue, quote the seaman");
		} else {
			// new for version 1.20	
			if ((restartMode==0) || (restartMode==19)) {
				//restart
				in1=20;	
				URLMode = true;
				beenHereDoneThat=false;
				restartMode=0;
				globalt=0;
				cDp = 0;
				countDown = Integer.parseInt(getParameter("countdown"),10);
				this.start();
			} else {
				activateURL();
			}
		}
	}

	public void mouseEntered(MouseEvent e) {}	// nope

	public void mouseExited(MouseEvent e) {}	// not me

	public void mouseClicked(MouseEvent e) {} // i think not

	// public void mouseDragged(MouseEvent e) {} no interest in this applet

	// public void mouseMoved(MouseEvent e) {} do not want to know :p <rasspppp>

	public void update(Graphics g) {
		if (wordList01 !=null || wordList02 != null)
		paint(g);
	}	

	public void start() {
		if(rndURL == null) 
		{
	       	rndURL = new Thread(this);
       		rndURL.start();
		}
	}

	public void stop() {
		rndURL = null;
		System.out.println("stopped applet running :(");	
	}

	public void run() {
		while (rndURL != null) {
			try {Thread.sleep(globalDelay);
				Thread.yield();
			} catch (InterruptedException e){}
			i1in++;
			if (i1in>in1) {
				URLUpdate();
				i1in=0;
			} else {
				repaint();
			}
		}
		rndURL = null;
	}

   	private int Randomize(int range) {
      	double rawResult;
      	rawResult=Math.random();
      	return (int) (rawResult * range);
   	}

} // end of main class


// load list is a utility class for loading text lists into a vectored list.
// rednuht 2001 (01)
// version 0.01
// it works, going to version 1.0
// 03022002 added the failed2load flag and LOADFAILED message

class loadList extends Applet implements Runnable {
	
// class vars
	public boolean loading = true;	// tells parent if we are ready yet	
	public int maxIndex = -1;	// contains the maximum index value for the vector list.
	
	Vector textList = new Vector();	// the actual vector of text strings
	// note parent class will NOT have direct access to this vector only via public functions.

	public boolean failed2load =false;

	public int byteCount;

	public URL sourceCodeBase;
	public String sourceURL;

	Thread sequence = null;

   	public void start() {
     		if(sequence==null) {
        		sequence=new Thread(this);
        		sequence.start();
     		}	
   	}

   	public void stop() {
     		if(sequence!=null) {
        		sequence.interrupt();
			sequence=null;
     		}	
   	}

	// data loader
	public void loadListData (URL scb, String sURL) {
		sourceCodeBase = scb;
		sourceURL = sURL;
	}

	// here it begins
	public void run() {
		beginLoadList();
		Thread.yield();	
		this.stop();
	} //  end of run

	public void beginLoadList () {
		String dataStr="";
 		try {
	            URL dataurl = null;
      	      BufferedInputStream disi = null;
            	dataurl = new URL(sourceCodeBase+sourceURL);
			InputStream in = dataurl.openStream(); 
	            disi = new BufferedInputStream(in);
			int	b = disi.read(); // good old 8 bit ascii
            	while (b != -1)	// same as while not eof
	          	{
				if ((b == 10) || (b == 13)) {
					if (dataStr.length()>=1) {
						// end of the string add it to the vector
						textList.addElement(new String(dataStr) );
						maxIndex++;
					}
					dataStr = "";
				} else {
					dataStr=dataStr + (char)b;					
				}
				// store input byte in a array
            	      b = disi.read();
				Thread.yield();	// b nice
				byteCount++;
	            } 
			// add the final record as EOF was its terminator
			if (dataStr.length()>1) {
				// end of the string add it to the vector
				textList.addElement(new String(dataStr) );
				maxIndex++;
			}
	      } catch (IOException e) {
	     	      System.out.println("loadList file/URL lost control: " + e.getMessage());
			failed2load=true;
			textList.addElement(new String("---LOADFAILED---") );
			maxIndex++;
      	}
		loading=false; 
		System.out.println("loading of [" + sourceURL + "] completed, loaded [" + (1+maxIndex) + "] records");
	}

	public String returnStrAtIndex (int indx) {
		if (!failed2load) {
			return((String)textList.elementAt(indx));
		} else {
			return("---LOADFAILED---");
		}
	}
} // enof loadList class
